﻿Imports System.IO.Ports
Imports System.Threading
Imports System.ComponentModel

Public Delegate Sub DataReceivedSyncEventHandler(ByVal e As DataReceivedSyncEventArgs)

Public Class DataReceivedSyncEventArgs
    Inherits System.EventArgs

    Private _ReceivedData As String

    Public Sub New(ByVal ReceivedData As String)
        MyBase.New()
        _ReceivedData = ReceivedData
    End Sub

    Public ReadOnly Property ReceivedData
        Get
            Return _ReceivedData
        End Get
    End Property

End Class

Public Class RS232
    'This class encapsulates System.IO.Ports.SerialPort and adds an event which is raised if a 
    'complete line of data is received. In contrast to the DataReceived event of the SerialPort
    'class, this event is not fired in a separate thread.

    Private onDataReceivedSyncDelegate As SendOrPostCallback
    Private Delegate Sub DataRxEventHandler(ByVal asyncOp As AsyncOperation)

    Private SerialPort As New System.IO.Ports.SerialPort

    Public Event DataReceivedSync As DataReceivedSyncEventHandler

    Public Sub New()
        onDataReceivedSyncDelegate = New SendOrPostCallback(AddressOf DataRx)
    End Sub

    Public Sub Open()
        SerialPort.Open()

        Dim asyncOp As AsyncOperation = AsyncOperationManager.CreateOperation(Nothing)
        Dim DataReceiver As New DataRxEventHandler(AddressOf ReceiveData)
        DataReceiver.BeginInvoke(asyncOp, Nothing, Nothing)
    End Sub

    Private Sub DataRx(ByVal ReceivedData As Object)
        Dim e As DataReceivedSyncEventArgs = ReceivedData

        RaiseEvent DataReceivedSync(e)

    End Sub

    Private Sub ReceiveData(ByVal asyncOp As AsyncOperation)
        Dim ReceivedData As String
        Dim e As DataReceivedSyncEventArgs = Nothing

        Do
            Try
                ReceivedData = SerialPort.ReadLine
                e = New DataReceivedSyncEventArgs(ReceivedData)
                asyncOp.Post(Me.onDataReceivedSyncDelegate, e)
            Catch ex As Exception

            End Try
        Loop While SerialPort.IsOpen
    End Sub

    'methods which just pass throught to the SerialPort object
#Region "SerialPort Methods"

    Public Sub Close()
        SerialPort.Close()
    End Sub

    Public Function GetPortNames() As String()
        Return SerialPort.GetPortNames
    End Function

    Public Sub Write(ByVal text As String)
        SerialPort.Write(text)
    End Sub

    Public Sub WriteLine(ByVal text As String)
        Try
            SerialPort.WriteLine(text)
        Catch ex As Exception
        End Try
    End Sub

#End Region

    'proberties which just pass throught to the SerialPort object
#Region "SerialPort Properties"

    Public Property BaudRate As Integer
        Get
            Return SerialPort.BaudRate
        End Get
        Set(ByVal BaudRate As Integer)
            SerialPort.BaudRate = BaudRate
        End Set
    End Property

    Public Property DataBits As Integer
        Get
            Return SerialPort.DataBits
        End Get
        Set(ByVal DataBits As Integer)
            SerialPort.DataBits = DataBits
        End Set
    End Property

    Public Property Encoding As System.Text.Encoding
        Get
            Return SerialPort.Encoding
        End Get
        Set(ByVal Encoding As System.Text.Encoding)
            SerialPort.Encoding = Encoding
        End Set
    End Property

    Public Property Handshake As System.IO.Ports.Handshake
        Get
            Return SerialPort.Handshake
        End Get
        Set(ByVal Handshake As System.IO.Ports.Handshake)
            SerialPort.Handshake = Handshake
        End Set
    End Property

    Public ReadOnly Property IsOpen As Boolean
        Get
            Return SerialPort.IsOpen
        End Get
    End Property

    Public Property NewLine As String
        Get
            Return SerialPort.NewLine
        End Get
        Set(ByVal NewLine As String)
            SerialPort.NewLine = NewLine
        End Set
    End Property

    Public Property Parity As System.IO.Ports.Parity
        Get
            Return SerialPort.Parity
        End Get
        Set(ByVal Parity As System.IO.Ports.Parity)
            SerialPort.Parity = Parity
        End Set
    End Property

    Public Property StopBits As System.IO.Ports.StopBits
        Get
            Return SerialPort.StopBits
        End Get
        Set(ByVal StopBits As System.IO.Ports.StopBits)
            SerialPort.StopBits = StopBits
        End Set
    End Property

    Public Property PortName As String
        Get
            Return SerialPort.PortName
        End Get
        Set(ByVal PortName As String)
            SerialPort.PortName = PortName
        End Set
    End Property

#End Region


End Class
